% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{interval}
\alias{interval}
\title{Cut Numeric Into Factor}
\usage{
interval(fun, breaks, ..., labels = NULL, include.lowest = FALSE,
  right = TRUE, dig.lab = 3, ordered_result = FALSE, n)
}
\arguments{
\item{fun}{A vector producing function.}

\item{breaks}{Either a numeric vector of two or more unique cut points or a
single number (greater than or equal to 2) giving the number of intervals
into which the vector produced from \code{fun} is to be cut.}

\item{labels}{Labels for the levels of the resulting category. By default,
labels are constructed using "(a,b]" interval notation. If
\code{labels = FALSE}, simple integer codes are returned instead of a factor.}

\item{include.lowest}{logical.  If \code{TRUE} an 'x[i]' equal to the lowest
(or highest, for \code{right = FALSE}) 'breaks' value should be included.}

\item{right}{logical.  If \code{TRUE} the intervals will be closed on the
right (and open on the left).}

\item{dig.lab}{An integer which is used when labels are not given. It
determines the number of digits used in formatting the break numbers.}

\item{ordered_result}{logical.  If \code{TRUE} the result be an ordered
factor.}

\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{\ldots}{Other arguments passed to \code{fun}.}
}
\value{
Returns a \code{\link[base]{cut}} factor vector.
}
\description{
A wrapper for \code{\link[base]{cut}} that cuts the vector and then adds the
\code{varname} produced by the original function.
}
\examples{
interval(normal, 4, n=100)
attributes(interval(normal, 4, n=100))
interval(age, 3, n = 1000)
}
\seealso{
\code{\link[base]{cut}}
}
\keyword{cut}
\keyword{interval}
