# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fast Matrix Transpose
#' 
#' Computes using RcppEigen transposed of A
#' 
#' @param A is the matrix being transposed
#' 
#' @return transpose of A
#' @examples
#' \dontrun{
#' rcppeigen_ftrans(A)
#' }
#' 
rcppeigen_ftrans <- function(A) {
    .Call('walkr_rcppeigen_ftrans', PACKAGE = 'walkr', A)
}

#' Fast Matrix Inverse
#' 
#' Computes using RcppEigen the inverse of A
#' 
#' @param A is the matrix being inverted
#' 
#' @return inverse of A
#' 
#' @examples
#' \dontrun{
#' rcppeigen_fsolve(A)
#' }
#' 
rcppeigen_fsolve <- function(A) {
    .Call('walkr_rcppeigen_fsolve', PACKAGE = 'walkr', A)
}

#' Fast Matrix Determinant
#' 
#' Computes using RcppEigen the determinant of A
#' 
#' @param A is the matrix whose determinant calculated 
#' 
#' @return determinant of A
#' 
#' @examples
#' \dontrun{
#' rcppeigen_fdet(A)
#' }
#' 
rcppeigen_fdet <- function(A) {
    .Call('walkr_rcppeigen_fdet', PACKAGE = 'walkr', A)
}

#' Fast Matrix Product
#' 
#' Computes using RcppEigen the product of A and B
#' 
#' @param A is the first parameter in A times B
#' @param B is the second parameter in A times B
#' 
#' @return matrix product A times B
#' 
#' @examples
#' \dontrun{
#' rcppeigen_fprod(A, B)
#' }
#' 
rcppeigen_fprod <- function(A, B) {
    .Call('walkr_rcppeigen_fprod', PACKAGE = 'walkr', A, B)
}

#' Fast Matrix Cross-Product
#' 
#' Computes using RcppEigen the product of t(A) and B
#' 
#' @param A is the first parameter in t(A) times B
#' @param B is the second parameter in t(A) times B
#' 
#' @return matrix cross-product t(A) times B
#' 
#' @examples
#' \dontrun{
#' rcppeigen_fcrossprod(A, B)
#' }
#' 
rcppeigen_fcrossprod <- function(A, B) {
    .Call('walkr_rcppeigen_fcrossprod', PACKAGE = 'walkr', A, B)
}

#' Fast Matrix T-Cross-Product
#' 
#' Computes using RcppEigen the product of A and t(B)
#' 
#' @param A is the first parameter in A times t(B)
#' @param B is the second parameter in A times t(B)
#' 
#' @return matrix tcross-product A times t(B)
#' 
#' @examples
#' \dontrun{
#' rcppeigen_ftcrossprod(A, B)
#' }
#' 
rcppeigen_ftcrossprod <- function(A, B) {
    .Call('walkr_rcppeigen_ftcrossprod', PACKAGE = 'walkr', A, B)
}

