% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sig2noise.R
\name{sig2noise}
\alias{sig2noise}
\title{Measure signal to noise ratio}
\usage{
sig2noise(X, mar)
}
\arguments{
\item{X}{data frame output from manualoc().}

\item{mar}{numeric vector of length one. Specifies the margins to subtract
from/add to start and end points of manualoc() selection, respectively,
over which to measure noise.}
}
\value{
manualoc data frame with a new variable for signal to noise
  calculations.
}
\description{
\code{sig2noise} measure signal to noise ratio across multiple files.
}
\details{
A general margin to apply before and after the acoustic signal must
  be specified. Setting margins for individual calls that have been
  previously clipped from larger files may take some optimization, as will
  margins for calls within a larger file that are irregularly separated. When
  margins overlap with another acoustic signal close by, the signal to noise
  ratio (SNR) will be inaccurate. Any SNRs less than or equal to one suggest
  background noise is equal to or overpowering the acoustic signal.
  \code{\link{snrspecs}} can be used to troubleshoot different noise margins.
}
\examples{
\dontrun{
 data(list = c("Arre.aura","manualoc.df"))
writeWave(Arre.aura, "Arre.aura.wav") #save sound files

# specifying the correct margin is important
# use snrspecs to troubleshoot margins for sound files
sig2noise(manualoc.df[grep("Arre", manualoc.df$sound.files), ], mar = 0.2)

# this smaller margin doesn't overlap neighboring calls
sig2noise(manualoc.df[grep("Arre", manualoc.df$sound.files), ], mar = 0.1)
}
}
\author{
Marcelo Araya-Salas http://marceloarayasalas.weebly.com/ and Grace Smith Vidaurre
}

