% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate.R
\name{consolidate}
\alias{consolidate}
\title{Consolidate (sound) files into a single folder}
\usage{
consolidate(files = NULL, path = NULL, dest.path = NULL, pb = TRUE, file.ext = ".wav$", 
parallel = 1, save.csv = TRUE, ...)
}
\arguments{
\item{files}{character vector or factor indicating the subset of files that will be analyzed. The files names
should include the full file path. Optional.}

\item{path}{Character string containing the directory path where the sound files are located. 
'wav.path' set by \code{\link{warbleR_options}} is ignored. 
If \code{NULL} (default) then the current working directory is used.}

\item{dest.path}{Character string containing the directory path where the cut sound files will be saved.
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{file.ext}{Character string defining the file extension for the files to be consolidated. Default is \code{'.wav$'} ignoring case.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{save.csv}{Logical. Controls whether a data frame containing sound file information is saved in the new folder.}

\item{...}{Additional arguments to be passed to the internal \code{\link[base]{file.copy}} function for customizing file copyin.}
}
\value{
All (sound) files are consolidated (copied) to a single folder ("consolidated_files"). If  \code{csv = TRUE} (default)
a '.csv' file with the information about file location, old and new names (if any renaming happen) is also saved in the same folder. This data frame is also return as an object in the R environment.
}
\description{
\code{consolidate} copies (sound) files scattered in several directories into a single folder.
}
\details{
This function allow users to put files scattered in several folders in a 
single folder. By default it works on sound files in '.wav' format but can work with
other type of files (for instance '.txt' selection files).
}
\examples{
{ 
# First set empty folder
# setwd(tempdir())

# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))

# create first folder
dir.create("folder1")
writeWave(Phae.long1, file.path("folder1","Phae.long1.wav"))
writeWave(Phae.long2, file.path("folder1","Phae.long2.wav"))

# create second folder
dir.create("folder2")
writeWave(Phae.long3, file.path("folder2","Phae.long3.wav"))
writeWave(Phae.long4, file.path("folder2","Phae.long4.wav"))

# consolidate in a single folder
consolidate()

# or if tempdir wa used
# consolidate(path = tempdir())
}

}
\seealso{
\code{\link{fixwavs}} for making sound files readable in R

Other selection manipulation, sound file manipulation: \code{\link{cut_sels}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
