% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_sels.R
\name{cut_sels}
\alias{cut_sels}
\title{Cut selections into individual sound files}
\usage{
cut_sels(X, mar = 0.05, parallel = 1, path = NULL, dest.path = NULL, pb = TRUE,
labels = c("sound.files", "selec"), overwrite = FALSE, ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signals (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the start and end points of selections,
dealineating spectrogram limits. Default is 0.05.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{dest.path}{Character string containing the directory path where the cut sound files will be saved.
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{labels}{String vector. Provides the column names that will be used as labels to
create sound file names. Note that they should provide unique names (otherwise 
sound files will be overwritten). Default is \code{c("sound.files", "selec")}.}

\item{overwrite}{Logical. If \code{TRUE} sound files with the same name will be 
overwritten. Default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to the internal \code{\link[tuneR]{writeWave}}  function for customizing sound file output (e.g. normalization).}
}
\value{
Sound files of the signals listed in the input data frame.
}
\description{
\code{cut_sels} cuts selections from a selection table into individual sound files.
}
\details{
This function allow users to produce individual sound files from the selections
listed in a selection table as in \code{\link{selec.table}}.
}
\examples{
{ 
# First set empty folder
# setwd(tempdir())

# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

# make spectrograms

cut_sels(selec.table)
 
cut_sels(selec.table, overwrite = TRUE, labels = c("sound.files", "selec", "sel.comment"))
 
 #check this folder!!
getwd()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{seltailor}} for tailoring selections 
 \href{https://marce10.github.io/2017/06/06/Individual_sound_files_for_each_selection.html}{blog post on cutting sound files}

Other selection manipulation, sound file manipulation: \code{\link{consolidate}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}
\concept{selection manipulation, sound file manipulation}
