% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_table.R
\name{fix_extended_selection_table}
\alias{fix_extended_selection_table}
\title{Fix extended selection tables}
\usage{
fix_extended_selection_table(X, Y)
}
\arguments{
\item{X}{an object of class 'selection_table' or data frame that contains columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end).}

\item{Y}{an object of class 'extended_selection_table'}
}
\description{
\code{fix_extended_selection_table} fixes extended selection tables that have lost their attributes
}
\examples{
{
# First set temporary folder
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))

# setwd(tempdir())

writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

# create extended selection table
ext_st <- selection_table(selec.table, extended = TRUE, confirm.extended = FALSE)

# remove attributes
st <- as.data.frame(ext_st)

# check class
class(st)

# fix selection table
st <- fix_extended_selection_table(X = st, Y = ext_st)

# check class
class(st)
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
