% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_table.R
\name{fix_extended_selection_table}
\alias{fix_extended_selection_table}
\title{Fix extended selection tables}
\usage{
fix_extended_selection_table(X, Y, to.by.song = FALSE)
}
\arguments{
\item{X}{an object of class 'selection_table' or data frame that contains columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end).}

\item{Y}{an object of class 'extended_selection_table'}

\item{to.by.song}{Logical argument to control if the attributes are formatted to a match a 'by.song' extended selection table. This is required when 'X' is created by collapsing an Y by song (see 'by.song' argument in \code{\link{selection_table}}). Mostly needed internally by some warbleR functions.}
}
\description{
\code{fix_extended_selection_table} fixes extended selection tables that have lost their attributes
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# create extended selection table
ext_st <- selection_table(lbh_selec_table, extended = TRUE, confirm.extended = FALSE, 
path = tempdir())

# remove attributes
st <- as.data.frame(ext_st)

# check class
class(st)

# fix selection table
st <- fix_extended_selection_table(X = st, Y = ext_st)

# check class
class(st)
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
