% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lspec2pdf.R
\name{lspec2pdf}
\alias{lspec2pdf}
\title{\code{lspec2pdf} combines \code{\link{lspec}} images in .jpeg format to a single pdf file.}
\usage{
lspec2pdf(keep.jpeg = TRUE, overwrite = FALSE, parallel = 1, path = NULL)
}
\arguments{
\item{keep.jpeg}{Logical argument. Indicates whether jpeg files should be kept (default) or remove.
(including sound file and page number) should be magnified. Default is 1.}

\item{overwrite}{Logical argument. If \code{TRUE} all jpeg pdf will be produced again 
when code is rerun. If \code{FALSE} only the ones missing will be produced. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}
}
\description{
\code{lspec2pdf} combines \code{\link{lspec}} images in .jpeg format to a single pdf file.
}
\details{
The function combines  spectrograms for complete sound files from the \code{\link{lspec}} function into
a single pdf (for each sound file).
}
\examples{
\dontrun{
# First create empty folder
setwd(tempdir())

# save sound file examples
data(list = c("Phae.long1", "Phae.long2"))
writeWave(Phae.long1,"Phae.long1.wav") 
writeWave(Phae.long2,"Phae.long2.wav")

lspec(sxrow = 2, rows = 8, pal = reverse.heat.colors, wl = 300, it = "jpeg")

#now create single pdf removing jpeg
lspec2pdf(keep.jpeg = FALSE)

check this floder
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}

