% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliceData.R
\name{sliceData}
\alias{sliceData}
\title{sliceData}
\usage{
sliceData(waspas_db, output_obj)
}
\arguments{
\item{waspas_db}{A matrix or data.frame in “all - in - one” format}

\item{output_obj}{A flag to determine the vector or matrix (data.frame)
to extract from the input matrix must be 'A' (Alternatives), 'C' (Criteria),
'F' (Flags), 'V' (Values) or 'W' (Weights)}
}
\value{
A data.frame one - dimensional (vector) or two - dimensional (matrix)
with one of the Following objects:
 - if output_obj == "A": A vector of Alternatives
 - if output_obj == "C": A vector of Criteria
 - if output_obj == "F": A vector of Cost - Benefit Flags
 - if output_obj == "I": A vector containing the indicators in cells [1:3, 1]
 - if output_obj == "V": A matrix of values per Alternative x Criterion
 - if output_obj == "W": A vector of Weights
}
\description{
Slice a matrix or data.frame in “all - in - one” format into
dedicated vectors/matrices as data.frame objects
}
\examples{

\donttest{
AlternativesList <- sliceData(waspas_db, "A")
CriteriaList <- sliceData(waspas_db, "C")
cost_benefit_Flags <- sliceData(waspas_db, "F")
values_matrix <- sliceData(waspas_db, "M")
vectorWeights <- sliceData(waspas_db, "W")
}
}
