% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgennls.R
\name{wgennls}
\alias{wgennls}
\title{wgennls}
\usage{
wgennls(A, u, sig, k)
}
\arguments{
\item{A}{is the amplitude of waveform.}

\item{u}{is a location parameter in the Weibull model, but this one is different from Gaussian or adaptive Gaussian distribution.}

\item{sig}{the scale parameter that controls the spread of the distribution,sig>0.}

\item{k}{is the shape parameter that controls the behaviour or the shape of distribution, k>0.}
}
\value{
A formula suitable for different number of waveform componments with Weibull distribution.
}
\description{
The function allows you to prepare the formula and start values for the decomposition using Weibull functions.
}
\examples{

A<-c(1000,900,1500);u<-c(-3,-5,0);sig<-c(30,40,75); k<-c(3,3,3)
##these four should have the same length
fg<-wgennls(A,u,sig,k)
##input formula for Gaussian decomposition
fgf<-fg$formula
###start values
fgs<-fg$start
}
