% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed.intervals.R
\name{fixed.intervals}
\alias{fixed.intervals}
\title{Fixed intervals}
\usage{
fixed.intervals(n, M)
}
\arguments{
\item{n}{a number of endpoints to choose from}

\item{M}{a number of intervals to generate}
}
\value{
a 2-column matrix with start (first column) and end (second column) points of an interval in each row
}
\description{
The function generates approximately \code{M} intervals with endpoints in \code{1},\code{2},...,\code{n}, without random drawing. This routine 
can be used inside \code{\link{wbs}} function and is typically not called directly by the user.
}
\details{
Function finds the minimal \code{m} such that \eqn{M\leq \frac{m(m-1)}{2}}{\code{M} <= \code{m(m-1)/2}}. 
Then it generates \code{m} approximately equally-spaced positive integers lower than \code{n} and returns all possible intervals consisting of any two of these points.
}
\examples{
fixed.intervals(10,100)
}
\seealso{
\code{\link{random.intervals}} \code{\link{wbs}}
}
