##
## wdnet: Weighted directed network
## Copyright (C) 2022  Yelie Yuan, Tiandong Wang, Jun Yan and Panpan Zhang
## Jun Yan <jun.yan@uconn.edu>
##
## This file is part of the R package wdnet.
##
## The R package wdnet is free software: You can redistribute it and/or
## modify it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or any later
## version (at your option). See the GNU General Public License at
## <https://www.gnu.org/licenses/> for details.
##
## The R package wdnet is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
##

# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

hello_world <- function() {
    invisible(.Call(`_wdnet_hello_world`))
}

fx <- function(x, Y, z) {
    .Call(`_wdnet_fx`, x, Y, z)
}

#' Degree preserving rewiring process for directed networks.
#'
#' @param iteration Integer, number of iterations of nattempts rewiring attempts.
#' @param nattempts Integer, number of rewiring attempts per iteration.
#' @param targetNode Vector, target node sequence - 1.
#' @param sourceOut Vector, source nodes' out-degree.
#' @param sourceIn Vector, source nodes' in-degree.
#' @param targetOut Vector, target nodes' out-degree.
#' @param targetIn Vector, target nodes' in-degree.
#' @param index_s Index of source nodes' out- and in-degree. 
#'   index_s/index_t bridges the indices of source/target nodes and the 
#'   target structure eta.
#' @param index_t Index of target nodes' out- and in-degree. 
#' @param eta Matrix, target structure eta generated by
#'   \code{wdnet::get_eta_directed()}.
#' @param rewire_history Logical, whether the rewiring history should be returned.
#' @return Target node sequence, four directed assortativity coefficients after
#'   each iteration, and rewire history.
#'
dprewire_directed_cpp <- function(iteration, nattempts, targetNode, sourceOut, sourceIn, targetOut, targetIn, index_s, index_t, eta, rewire_history) {
    .Call(`_wdnet_dprewire_directed_cpp`, iteration, nattempts, targetNode, sourceOut, sourceIn, targetOut, targetIn, index_s, index_t, eta, rewire_history)
}

#' Degree preserving rewiring process for undirected networks.
#' 
#' @param iteration Integer, number of iterations of nattempts rewiring attempts.
#' @param nattempts Integer, number of rewiring attempts per iteration.
#' @param node1 Vector, first column of edgelist.
#' @param node2 Vector, second column of edgelist.
#' @param degree1 Vector, degree of node1 and node2.
#' @param degree2 Vector, degree of node2 and node1. degree1 
#'   and degree2 are used to calculate assortativity coefficient,
#'   i.e., degree correlation.
#' @param index1 Index of the first column of edgelist. 
#'   index1 and index2 bridge the nodes' degree and the 
#'   structure e.
#' @param index2 Index of the second column of edgelist..
#' @param e Matrix, target structure e (eta) generated by
#'   \code{wdnet::get_eta_undirected()}.
#' @param rewire_history Logical, whether the rewiring history should be returned.
#' @return Node sequences, assortativity coefficient after each iteration
#'   and rewiring history.
#'
dprewire_undirected_cpp <- function(iteration, nattempts, node1, node2, degree1, degree2, index1, index2, e, rewire_history) {
    .Call(`_wdnet_dprewire_undirected_cpp`, iteration, nattempts, node1, node2, degree1, degree2, index1, index2, e, rewire_history)
}

#' Preferential attachment algorithm.
#'
#' @param nstep Number of steps.
#' @param m Number of new edges in each step.
#' @param new_node_id New node ID.
#' @param new_edge_id New edge ID.
#' @param source_node Sequence of source nodes.
#' @param target_node Sequence of target nodes.
#' @param outs Sequence of out-strength.
#' @param ins Sequence of in-strength.
#' @param edgeweight Weight of existing and new edges.
#' @param scenario Scenario of existing and new edges.
#' @param sample_recip Logical, whether reciprocal edges will be added.
#' @param node_group Sequence of node group.
#' @param source_pref Sequence of node source preference.
#' @param target_pref Sequence of node target preference.
#' @param control List of controlling arguments.
#' @return Sampled network.
#'
rpanet_binary_directed <- function(nstep, m, new_node_id, new_edge_id, source_node, target_node, outs, ins, edgeweight, scenario, sample_recip, node_group, source_pref, target_pref, control) {
    .Call(`_wdnet_rpanet_binary_directed`, nstep, m, new_node_id, new_edge_id, source_node, target_node, outs, ins, edgeweight, scenario, sample_recip, node_group, source_pref, target_pref, control)
}

#' Preferential attachment algorithm.
#'
#' @param nstep Number of steps.
#' @param m Number of new edges in each step.
#' @param new_node_id New node ID.
#' @param new_edge_id New edge ID.
#' @param node_vec1 Sequence of nodes in the first column of edgelist.
#' @param node_vec2 Sequence of nodes in the second column of edgelist.
#' @param strength Sequence of node strength.
#' @param edgeweight Weight of existing and new edges.
#' @param scenario Scenario of existing and new edges.
#' @param pref Sequence of node preference.
#' @param control List of controlling arguments.
#' @return Sampled network.
#'
rpanet_binary_undirected_cpp <- function(nstep, m, new_node_id, new_edge_id, node_vec1, node_vec2, strength, edgeweight, scenario, pref, control) {
    .Call(`_wdnet_rpanet_binary_undirected_cpp`, nstep, m, new_node_id, new_edge_id, node_vec1, node_vec2, strength, edgeweight, scenario, pref, control)
}

#'  Preferential attachment algorithm.
#' 
#' @param nstep Number of steps.
#' @param m Number of new edges in each step.
#' @param new_node_id New node ID.
#' @param new_edge_id New edge ID.
#' @param source_node Sequence of source nodes.
#' @param target_node Sequence of target nodes.
#' @param outs Sequence of out-strength.
#' @param ins Sequence of in-strength.
#' @param edgeweight Weight of existing and new edges.
#' @param scenario Scenario of existing and new edges.
#' @param sample_recip Logical, whether reciprocal edges will be added.
#' @param node_group Sequence of node group.
#' @param source_pref Sequence of node source preference.
#' @param target_pref Sequence of node target preference.
#' @param control List of controlling arguments.
#' @return Sampled network.
#'
rpanet_naive_directed_cpp <- function(nstep, m, new_node_id, new_edge_id, source_node, target_node, outs, ins, edgeweight, scenario, sample_recip, node_group, source_pref, target_pref, control) {
    .Call(`_wdnet_rpanet_naive_directed_cpp`, nstep, m, new_node_id, new_edge_id, source_node, target_node, outs, ins, edgeweight, scenario, sample_recip, node_group, source_pref, target_pref, control)
}

#' Preferential attachment algorithm.
#'
#' @param nstep Number of steps.
#' @param m Number of new edges in each step.
#' @param new_node_id New node ID.
#' @param new_edge_id New edge ID.
#' @param node_vec1 Sequence of nodes in the first column of edgelist.
#' @param node_vec2 Sequence of nodes in the second column of edgelist.
#' @param strength Sequence of node strength.
#' @param edgeweight Weight of existing and new edges.
#' @param scenario Scenario of existing and new edges.
#' @param pref Sequence of node preference.
#' @param control List of controlling arguments.
#' @return Sampled network.
#'
rpanet_naive_undirected_cpp <- function(nstep, m, new_node_id, new_edge_id, node_vec1, node_vec2, strength, edgeweight, scenario, pref, control) {
    .Call(`_wdnet_rpanet_naive_undirected_cpp`, nstep, m, new_node_id, new_edge_id, node_vec1, node_vec2, strength, edgeweight, scenario, pref, control)
}

#' Preferential attachment algorithm for simple situations, 
#' i.e., edge weight equals to 1, number of new edges per step is 1.
#'
#' @param snode Source nodes.
#' @param tnode Target nodes.
#' @param scenario Sequence of alpha, beta, gamma, xi, rho scenarios.
#' @param nnode Number of nodes in seed network.
#' @param nedge Number of edges in seed network.
#' @param delta_out Tuning parameter.
#' @param delta_in Tuning parameter.
#' @param directed Whether the network is directed.
#' @return Number of nodes, sequences of source and target nodes.
#' 
rpanet_nodelist_cpp <- function(snode, tnode, scenario, nnode, nedge, delta_out, delta_in, directed) {
    .Call(`_wdnet_rpanet_nodelist_cpp`, snode, tnode, scenario, nnode, nedge, delta_out, delta_in, directed)
}

#' Fill missing nodes in the node sequence. Defined for \code{wdnet::rpanet}.
#'
#' @param nodes Source/target nodes, missing nodes are denoted as 0.
#' @param edges Sampled edges according to preferential attachment.
#' @return Source/target nodes.
find_node_cpp <- function(nodes, edges) {
    .Call(`_wdnet_find_node_cpp`, nodes, edges)
}

#' Fill missing values in node sequence. Defined for \code{wdnet::rpanet}.
#'
#' @param node1 Nodes in the first column of edgelist, i.e., \code{edgelist[, 1]}.
#' @param node2 Nodes in the second column of edgelist, i.e., \code{edgelist[, 2]}.
#' @param start_edge Index of sampled edges, corresponds to the missing nodes in node1 and node2.
#' @param end_edge Index of sampled edges, corresponds to the missing nodes in node1 and node2.
#' @return Node sequence.
find_node_undirected_cpp <- function(node1, node2, start_edge, end_edge) {
    .Call(`_wdnet_find_node_undirected_cpp`, node1, node2, start_edge, end_edge)
}

#' Aggregate edgeweight into nodes' strength.
#'
#' @param snode Source nodes.
#' @param tnode Target nodes.
#' @param weight Edgeweight.
#' @param nnode Number of nodes.
#' @param weighted Logical, true if the edges are weighted, 
#'   false if not.
#' @return Out-strength and in-strength.
node_strength_cpp <- function(snode, tnode, weight, nnode, weighted = TRUE) {
    .Call(`_wdnet_node_strength_cpp`, snode, tnode, weight, nnode, weighted)
}

#' Uniformly draw a node from existing nodes for each time step.
#' Defined for \code{wdnet::rpanet}.
#'
#' @param total_node Number of existing nodes at each time step.
#' @return Sampled nodes.
sample_node_cpp <- function(total_node) {
    .Call(`_wdnet_sample_node_cpp`, total_node)
}

#' Fill edgeweight into the adjacency matrix.
#' Defined for function \code{edge_to_adj}.
#'
#' @param adj An adjacency matrix.
#' @param edgelist A two column matrix represents the edgelist.
#' @param edgeweight A vector represents the weight of edges.
#' @return Adjacency matrix with edge weight.
fill_weight_cpp <- function(adj, edgelist, edgeweight) {
    .Call(`_wdnet_fill_weight_cpp`, adj, edgelist, edgeweight)
}

