% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Acf.R
\name{nl.acf}
\alias{nl.acf}
\title{Autocorrelogram}
\usage{
nl.acf(
  ar = NULL,
  ma = NULL,
  y,
  main = NULL,
  nlag = NULL,
  conflevel = 0.05,
  z = 1.2,
  aff = "both"
)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL}, we consider a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL}, we consider an AR process.}

\item{y}{Univariate time series.}

\item{main}{Character string representing the title for the plot.}

\item{nlag}{Maximum lag at which to calculate the acf. If \code{NULL}, it is
determinate by \eqn{nlag = min(10log(n))} where n is the number of
observation.}

\item{conflevel}{Value of the confidence level, 5\% by default.}

\item{z}{Zoom on the graph.}

\item{aff}{Specify the method between SN, M and both (see in Details).}
}
\value{
An autocorrelogram with every autocorrelations from 1 to a lag max, and 
with methods you choose to print.
}
\description{
Plots autocorrelogram for non linear process.
}
\details{
For the argument \code{aff} you have the choice between: 
 \code{SN}, \code{M} and \code{both}.
 \code{SN} prints the self-normalized method (see Boubacar Maïnassara and Saussereau) in green, 
 \code{M} prints the modified method introduced by Francq, Roy and Zakoïan (see also Boubacar Maïnassara) in red 
 and \code{both} prints both of the methods.
}
\note{
The only value available for the argument \code{conflevel} are 
 0.1, 0.05, 0.025, 0.01 or 0.005.
}
\examples{
est<-estimation(p = 1, q = 1, y = CAC40return.sq)
\donttest{nl.acf(ar = est$ar, ma = est$ma, y = CAC40return.sq, main = "Autocorrelation of an ARMA(1,1) 
residuals of the CAC40 return square", nlag = 20)}

}
\references{
Boubacar Maïnassara, Y. 2011, Multivariate portmanteau test for structural {VARMA} models
with uncorrelated but non-independent error terms \emph{Journal of Statistical Planning and Inference},
vol. 141, no. 8, pp. 2961-2975.

Boubacar Maïnassara, Y.and Saussereau, B. 2018, Diagnostic checking in multivariate {ARMA} models with 
dependent errors using normalized residual autocorrelations ,
 \emph{Journal of the American Statistical Association}, vol. 113, no. 524, pp. 1813-1827.

Francq, C., Roy, R. and Zakoïan, J.M. 2005, Diagnostic Checking in ARMA
 Models with Uncorrelated Errors, \emph{Journal of the American Statistical
 Association}, vol. 100, no. 470, pp. 532-544.

Lobato, I.N. 2001, Testing that a dependant process is
 uncorrelated. J. Amer. Statist. Assos. 96, vol. 455, pp. 1066-1076.
}
