% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophicSDM_CV.R
\name{trophicSDM_CV}
\alias{trophicSDM_CV}
\title{Compute K-fold cross-validation predicted values from a fitted trophicSDM model}
\usage{
trophicSDM_CV(
  tSDM,
  K,
  partition = NULL,
  prob.cov = FALSE,
  pred_samples = NULL,
  iter = NULL,
  chains = NULL,
  run.parallel = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{tSDM}{A trophicSDMfit object obtained with trophicSDM()}

\item{K}{The number of folds for the K-fold cross validation}

\item{partition}{Optional parameter. A partition vector to specify a partition in K fold for cross validation}

\item{prob.cov}{Parameter to predict with trophicSDM with presence-absence data. Whether to use predicted probability of presence (prob.cov = T) or the transformed presence-absences (default, prov.cov = F) to predict species distribution.}

\item{pred_samples}{Number of samples to draw from species posterior predictive distribution when method = "stan_glm". If NULL, set by the default to the number of iterations/10.}

\item{iter}{For method = "stan_glm": number of iterations of each MCMC chains to fit the trophicSDM model. Default to the number of iterations used to fit the provided trophicSDMfit object}

\item{chains}{For method = "stan_glm": number of MCMC chains to fit the trophicSDM model. Default to the number of iterations used to fit the provided trophicSDMfit object}

\item{run.parallel}{Whether to use parallelise code when possible. Default to TRUE. Can speed up computation time}

\item{verbose}{Whether to print advances of the algorithm}
}
\value{
A list containing:
\item{meanPred}{a sites x species matrix of predicted occurrences of species for each site (e.g. probability of presence). With stan_glm the posterior predictive mean is return}
\item{Pred975,Pred025}{Only for method = "stan_glm", the 97.5\% and 2.5\% quantiles of the predictive posterior distribution}
\item{partition}{the partition vector used to compute the K fold cross-validation}
}
\description{
Once the CV predicted values are obtained, their quality can be evaluated with \code{evaluateModelFit()}.
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
\donttest{
m = trophicSDM(Y, X, G, env.formula, iter = 50, 
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")

# Run a 3-fold (K=3) cross validation. Predictions is done using presence-absences of preys
# (prob.cov = FALSE, see ?predict.trophicSDM) with 50 draws from the posterior distribution
# (pred_samples = 50)
CV = trophicSDM_CV(m, K = 3, prob.cov = FALSE, pred_samples = 10, run.parallel = FALSE)
# Use predicted values to evaluate model goodness of fit in cross validation
Ypred = CV$meanPred[,colnames(Y)]

evaluateModelFit(m, Ynew = Y, Ypredicted = Ypred)
}
# Now with K = 2 and by specifying the partition of site
m = trophicSDM(Y, X, G, env.formula, iter = 50,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "glm")
partition = c(rep(1,500),rep(2,500))
CV = trophicSDM_CV(m, K = 2, partition = partition, prob.cov = FALSE,
                   pred_samples = 10, run.parallel = FALSE)
Ypred = CV$meanPred[,colnames(Y)]
evaluateModelFit(m, Ynew = Y, Ypredicted = Ypred)
}
\author{
Giovanni Poggiato
}
