% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdb.R
\name{ppdb}
\alias{ppdb}
\title{Query the ppdb for information}
\usage{
ppdb(cas, verbose = TRUE, index = NULL)
}
\arguments{
\item{cas}{character; CAS number to query.}

\item{verbose}{logical; print message during processing to console?}

\item{index}{A index object, as created by \code{\link{ppdb_buildidx}}.
If NULL (default), the index shipped with webchem is used \code{\link{ppdb_idx}}.}
}
\value{
A list of 10 data.frames : ec_regulation, approved_in, general, parents, fate,
deg, soil, metab, etox and names.

See also \url{http://sitem.herts.ac.uk/aeru/iupac/docs/Background_and_Support.pdf} for more information on the data
}
\description{
This function queries the PPDB \url{http://sitem.herts.ac.uk/aeru/iupac/search.htm} for information.
}
\examples{
\dontrun{
# might fail if Server is not available
gly <- ppdb('1071-83-6')
gly$approved_in

# handle multiple CAS
 cas <- c('1071-83-6', '50-00-0')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

