% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_convert}
\alias{cts_convert}
\title{Convert Ids using Chemical Translation Service (CTS)}
\usage{
cts_convert(query, from, to, first = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID, e.g. \code{'Chemical Name'} , \code{'InChIKey'},
\code{'PubChem CID'}, \code{'ChemSpider'}, \code{'CAS'}.}

\item{to}{character; type to convert to.}

\item{first}{logical; return only first result be returned?}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a character vector.
}
\description{
Convert Ids using Chemical Translation Service (CTS), see \url{http://cts.fiehnlab.ucdavis.edu/conversion/index}
}
\details{
See see \url{http://cts.fiehnlab.ucdavis.edu/conversion/index}
for possible values of from and to.
}
\examples{
\donttest{
# might fail if API is not available
cts_convert('XEFQLINVKFYRCS-UHFFFAOYSA-N', 'inchikey', 'Chemical Name')

### multiple inputs
comp <- c('XEFQLINVKFYRCS-UHFFFAOYSA-N', 'BSYNRYMUTXBXSQ-UHFFFAOYSA-N')
sapply(comp, function(x) cts_convert(x, 'inchikey', 'Chemical Name', first = TRUE))
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Wohlgemuth, G., P. K. Haldiya, E. Willighagen, T. Kind, and O. Fiehn 2010The Chemical Translation Service
-- a Web-Based Tool to Improve Standardization of Metabolomic Reports. Bioinformatics 26(20): 2647–2648.
}

