% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem.R
\name{pc_compinfo}
\alias{pc_compinfo}
\title{Retrieve compound information from pubchem CID}
\usage{
pc_compinfo(cid, first = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{cid}{character; Pubchem ID (CID).}

\item{first}{logical; return only first list items?
That is: a list with entries of lenght 1 (for easy conversion in a data.frame)}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list with entries: CID (Pubchem ID), InChIKey, InChI,
synonyms, IUPACName, Canonical SMILES, Isomeric SMILES, MolecularFormula,
MolecularWeight, TotalFormalCharge, XlogP, HydrogenBondDonorCount,
HydrogenBondAcceptorCount, Complexity,  HeavyAtomCount, AtomChiralCount,
AtomChiralDefCount, AtomChiralUndefCount, BondChiralCount, BondChiralDefCount,
BondChiralUndefCount, IsotopeAtomCount, CovalentUnitCount, TautomerCount and source_url
}
\description{
Retrieve compound information from pubchem CID, see \url{https://pubchem.ncbi.nlm.nih.gov/}
}
\examples{
\donttest{
# might fail if API is not available
cid <- get_pcid('Triclosan')
pc_compinfo(cid[1])

###
# multiple CIDS
comp <- c('Triclosan', 'Aspirin')
cids <- sapply(comp, function(x) get_pcid(x, first = TRUE))
(ll <- lapply(cids, pc_compinfo, first = TRUE))
# as mtrix
do.call(rbind, ll)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Wang, Y., J. Xiao, T. O. Suzek, et al. 2009 PubChem: A Public Information System for
Analyzing Bioactivities of Small Molecules. Nucleic Acids Research 37: 623–633.

Kim, Sunghwan, Paul A. Thiessen, Evan E. Bolton, et al. 2016
PubChem Substance and Compound Databases. Nucleic Acids Research 44(D1): D1202–D1213.
}
\seealso{
\code{\link{get_pcid}} to retrieve Pubchem IDs.
}

