% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebi.R
\name{get_chebiid}
\alias{get_chebiid}
\title{Retrieve Lite Entity (identifiers) from ChEBI}
\usage{
get_chebiid(
  query,
  from = c("all", "chebi id", "chebi name", "definition", "name", "iupac name",
    "citations", "registry numbers", "manual xrefs", "automatic xrefs", "formula",
    "mass", "monoisotopic mass", "charge", "inchi", "inchikey", "smiles", "species"),
  match = c("all", "best", "first", "ask", "na"),
  max_res = 200,
  stars = c("all", "two only", "three only"),
  verbose = getOption("verbose"),
  ...
)
}
\arguments{
\item{query}{character; search term.}

\item{from}{character; type of input.  \code{"all"} searches all types and
\code{"name"} searches all names. Other options include \code{'chebi id'},
\code{'chebi name'}, \code{'definition'}, \code{'iupac name'},
\code{'citations'}, \code{'registry numbers'}, \code{'manual xrefs'},
\code{'automatic xrefs'}, \code{'formula'}, \code{'mass'},
\code{'monoisotopic mass'},\code{'charge'}, \code{'inchi'},
\code{'inchikey'}, \code{'smiles'}, and \code{'species'}}

\item{match}{character; How should multiple hits be handled?, \code{"all"}
all matches are returned, \code{"best"} the best matching (by the ChEBI
searchscore) is returned, \code{"ask"} enters an interactive mode and the
user is asked for input, \code{"na"} returns NA if multiple hits are found.}

\item{max_res}{integer; maximum number of results to be retrieved from the
web service}

\item{stars}{character; "three only" restricts results to those manualy
annotated by the ChEBI team.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently unused}
}
\value{
returns a list of data.frames containing a chebiid, a chebiasciiname,
  a searchscore and stars if matches were found. If not, data.frame(NA) is
  returned
}
\description{
Returns a data.frame with a ChEBI entity ID (chebiid),
a ChEBI entity name (chebiasciiname), a search score (searchscore) and
stars (stars) using the SOAP protocol:
\url{https://www.ebi.ac.uk/chebi/webServices.do}
}
\examples{
\donttest{
# might fail if API is not available
get_chebiid('Glyphosate')
get_chebiid('BPGDAMSIGCZZLK-UHFFFAOYSA-N')

# multiple inputs
comp <- c('Iron', 'Aspirin', 'BPGDAMSIGCZZLK-UHFFFAOYSA-N')
get_chebiid(comp)

}
}
\references{
Hastings J, Owen G, Dekker A, Ennis M, Kale N, Muthukrishnan V,
  Turner S, Swainston N, Mendes P, Steinbeck C. (2016). ChEBI in 2016:
  Improved services and an expanding collection of metabfolites. Nucleic
  Acids Res.

  Hastings, J., de Matos, P., Dekker, A., Ennis, M., Harsha, B., Kale, N.,
  Muthukrishnan, V., Owen, G., Turner, S., Williams, M., and Steinbeck, C.
  (2013) The ChEBI reference database and ontology for biologically relevant
  chemistry: enhancements for 2013. Nucleic Acids Res.

  de Matos, P., Alcantara, R., Dekker, A., Ennis, M., Hastings, J., Haug, K.,
  Spiteri, I., Turner, S., and Steinbeck, C. (2010) Chemical entities of
  biological interest: an update. Nucleic Acids Res. Degtyarenko, K.,
  Hastings, J., de Matos, P., and Ennis, M. (2009). ChEBI: an open
  bioinformatics and cheminformatics resource. Current protocols in
  bioinformatics / editoral board, Andreas D. Baxevanis et al., Chapter 14.

  Degtyarenko, K., de Matos, P., Ennis, M., Hastings, J., Zbinden, M.,
  McNaught, A., Alcántara, R., Darsow, M., Guedj, M. and Ashburner, M. (2008)
  ChEBI: a database and ontology for chemical entities of biological
  interest. Nucleic Acids Res. 36, D344–D350.

Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
  Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
  Information from the Web. Journal of Statistical Software, 93(13).
  \doi{10.18637/jss.v093.i13}.
}
