% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cluster_button.R
\name{add_cluster_button}
\alias{add_cluster_button}
\title{Add cluster control button to a web map}
\usage{
add_cluster_button(map, cluster_id, position = "topleft")
}
\arguments{
\item{map}{'\link{leaflet}'.
Map widget object}

\item{cluster_id}{'character' string.
Identification for the marker cluster layer.}

\item{position}{'character' string.
Position of the button on the web map.
Possible values are \code{"topleft"}, \code{"topright"}, \code{"bottomleft"}, and \code{"bottomright"}.}
}
\value{
A new HTML web \code{map} with added element, an object of class 'leaflet'.
}
\description{
Add a button to a \href{https://leafletjs.com/}{Leaflet} map to toggle marker clusters on and off.
}
\examples{
# read city point locations from GeoJSON file
city <- system.file("extdata/city.geojson", package = "webmap") |>
  sf::st_read()

# create web map and add button to toggle marker clusters on and off
map <- make_map("Topo") |>
  leaflet::addMarkers(
    label = ~name,
    popup = ~name,
    clusterOptions = leaflet::markerClusterOptions(
      showCoverageOnHover = FALSE
    ),
    clusterId = "cluster",
    group = "marker",
    data = city
  ) |>
  add_cluster_button(cluster_id = "cluster")

# print web map
map
}
\seealso{
\code{\link{make_map}} function for creating a map widget.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
