% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label}
\alias{label}
\title{Label images}
\usage{
label(stimuli, ...)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{...}{arguments to pass on to \code{\link[=mlabel]{mlabel()}} or \code{\link[=gglabel]{gglabel()}}}
}
\value{
stimlist with labelled images
}
\description{
Defaults to \code{\link[=mlabel]{mlabel()}} unless you use arguments specific to \code{\link[=gglabel]{gglabel()}}. All arguments are vectorised over the stimuli and values are recycled or truncated if there are fewer or more than stimuli.
}
\examples{
stimuli <- demo_stim()

# label with magick::image_annotate
label(stimuli, 
      text = c("CHINWE", "GEORGE"), 
      gravity = c("north", "south"),
      color = "red")

# label with ggplot2::annotate
label(stimuli,
      label = c("CHINWE", "GEORGE"), 
      x = 0.5, 
      y = c(0.99, 0.02),
      vjust = c(1, 0), 
      size = 18,
      color = "red")
}
\seealso{
\code{\link[=mlabel]{mlabel()}}, \code{\link[=gglabel]{gglabel()}}

Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{draw_tem}()},
\code{\link{gglabel}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()},
\code{\link{plot_stim}()}
}
\concept{viz}
