% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_rows}
\alias{plot_rows}
\title{Plot in rows}
\usage{
plot_rows(
  ...,
  top_label = NULL,
  maxwidth = wm_opts("plot.maxwidth"),
  maxheight = wm_opts("plot.maxheight")
)
}
\arguments{
\item{...}{stimlists (optionally named) and any arguments to pass on to \code{\link{label}}}

\item{top_label}{logical; whether to plot row labels above the row (TRUE) or inside (FALSE), if NULL, then TRUE if stimlists are named}

\item{maxwidth, maxheight}{maximum width and height of each row in pixels}
}
\value{
stimlist with plot
}
\description{
Plot in rows
}
\examples{
s <- demo_unstandard()
plot_rows(
  female = s[1:3],
  male = s[6:8],
  maxwidth = 600
)
}
\seealso{
Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{draw_tem}()},
\code{\link{gglabel}()},
\code{\link{label}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_stim}()}
}
\concept{viz}
