% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squash_tem.R
\name{squash_tem}
\alias{squash_tem}
\title{Squash Template Points}
\usage{
squash_tem(stimuli)
}
\arguments{
\item{stimuli}{list of stimuli}
}
\value{
list of stimuli
}
\description{
Move template points that are outside the image boundaries (e.g., negative values or larger than image width or height) to the borders of the image.
}
\examples{
nosquash <- demo_stim(1) |> 
  crop(0.4, 0.5)

squash <- demo_stim(1) |> 
  crop(0.4, 0.5) |> 
  squash_tem()

# add padding and visualise templates
c(nosquash, squash) |> 
  pad(50) |>
  draw_tem(pt.size = 5) 
}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{delin}()},
\code{\link{draw_tem}()},
\code{\link{features}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{require_tems}()},
\code{\link{same_tems}()},
\code{\link{subset_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}
}
\concept{tem}
