% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetrise.R
\name{symmetrize}
\alias{symmetrize}
\alias{symmetrise}
\title{Symmetrize Images}
\usage{
symmetrize(stimuli, shape = 1, color = 1, tem_id = "frl", ...)

symmetrise(stimuli, shape = 1, color = 1, tem_id = "frl", ...)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{shape, color}{amount of symmetry (0 for none, 1.0 for perfect)}

\item{tem_id}{template ID to be passed to \code{\link[=tem_def]{tem_def()}} (usually "frl" or "fpp106")}

\item{...}{Additional arguments to pass to \code{\link[=trans]{trans()}}}
}
\value{
list of stimuli with symmetrised images and templates
}
\description{
Use webmorph.org to make faces symmetric in shape and/or colour.
}
\examples{
\donttest{
if (webmorph_up()) {
  stimuli <- demo_stim(1)

  sym_both <- symmetrize(stimuli)
  sym_shape <- symmetrize(stimuli, color = 0)
  sym_color <- symmetrize(stimuli, shape = 0)
  sym_anti <- symmetrize(stimuli, shape = -1.0, color = 0)
}
}
}
\seealso{
WebMorph.org functions
\code{\link{avg}()},
\code{\link{continuum}()},
\code{\link{loop}()},
\code{\link{trans}()},
\code{\link{webmorph_up}()}
}
\concept{webmorph}
