% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.r
\name{response}
\alias{response}
\title{Compile an HTTP response.}
\usage{
response(body = NULL, status = 200L, headers = NULL, ...)
}
\arguments{
\item{body}{The content. A list will be encoded as JSON. A scalar
integer will be interpreted as a status. A character vector
will be concatenated with no separator.}

\item{status}{A HTTP response status code.}

\item{headers}{A named character vector of HTTP headers. A list-like
object is acceptable if all elements are simple strings.}

\item{...}{Objects created by \code{header()} and/or \code{cookie()}. Or
key-value pairs to add to \code{headers}.}
}
\value{
A \verb{<response/AsIs>} object. Essentially a list with elements named
\code{body}, \code{status}, and \code{headers} formatted as 'httpuv' expects.
}
\description{
If your WebQueue's \code{handler} function returns a list, json object, character
vector, or scalar integer, \code{response()} will be used to transform that
result into an HTTP response.\cr\cr
You may also call \code{response()} within your handler to better customize the
HTTP response. Or, return a result of class 'AsIs' to have that object
passed directly on to 'httpuv'.
}
\examples{

    library(webqueue)
    
    response(list(name = unbox('Peter'), pi = pi))
         
    response(307L, Location = '/new/file.html')
    
    # The `body` and `status` slots also handle header objects.
    response(cookie(id = 123, http_only = TRUE))
    
    # Allow javascript to access custom headers.
    uid <- header('x-user-id'    = 100, expose = TRUE)
    sid <- header('x-session-id' = 303, expose = TRUE)
    response(uid, sid)
    
}
