% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{add_panelist_data}
\alias{add_panelist_data}
\title{Add panelist features to webtrack data
Add characteristics of panelists (e.g. from a survey) to the webtrack data}
\usage{
add_panelist_data(wt, data, cols = NULL)
}
\arguments{
\item{wt}{webtrack data object}

\item{data}{a data.table (or object that can be converted to data.table) which contains variables of panelists}

\item{cols}{character vector of columns to add. If NULL, all columns are added}
}
\value{
webtrack object with the same columns and joined with panelist survey data
}
\description{
Add panelist features to webtrack data
Add characteristics of panelists (e.g. from a survey) to the webtrack data
}
\examples{
data("test_data")
data("test_survey")
wt <- as.wt_dt(test_data)
add_panelist_data(wt,test_survey)
}
