# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

getLambda <- function(x, weights, status, beta) {
    .Call(`_weibulltools_getLambda`, x, weights, status, beta)
}

g <- function(x, weights, status, beta) {
    .Call(`_weibulltools_g`, x, weights, status, beta)
}

gDiv <- function(x, weights, beta) {
    .Call(`_weibulltools_gDiv`, x, weights, beta)
}

NewtonRaphson <- function(x, weights, status) {
    .Call(`_weibulltools_NewtonRaphson`, x, weights, status)
}

MStepWeibull <- function(x, posterior, status) {
    .Call(`_weibulltools_MStepWeibull`, x, posterior, status)
}

weibullDensity <- function(x, beta, lambda, censored) {
    .Call(`_weibulltools_weibullDensity`, x, beta, lambda, censored)
}

LikelihoodWeibull <- function(x, parameter, status, prior, P, logL) {
    invisible(.Call(`_weibulltools_LikelihoodWeibull`, x, parameter, status, prior, P, logL))
}

normalize <- function(M) {
    invisible(.Call(`_weibulltools_normalize`, M))
}

#' EM-Algorithm using Newton-Raphson Method
#'
#' This method uses the EM-Algorithm to estimate the parameters of a univariate
#' mixture model. Until now, the mixture model can consist of k two-parametric
#' Weibull distributions. The Weibull distributions are parameterized with scale
#' \eqn{\eta} and shape \eqn{\beta}. In M-step these parameters are estimated using
#' Newton-Raphson. This function is implemented in c++ and is called in function
#' \code{\link{mixmod_em}}.
#'
#' @encoding UTF-8
#' @references Doganaksoy, N.; Hahn, G.; Meeker, W. Q., Reliability Analysis by
#'   Failure Mode, Quality Progress, 35(6), 47-52, 2002
#'
#' @param x a numeric vector which consists of lifetime data. Lifetime
#'  data could be every characteristic influencing the reliability of a product,
#'  e.g. operating time (days/months in service), mileage (km, miles), load
#'  cycles.
#' @param status a vector of binary data (0 or 1) indicating whether unit \emph{i}
#'   is a right censored observation (= 0) or a failure (= 1).
#' @param post a numeric matrix specifying initial a-posteriori probabilities.
#'   The number of rows have to be in line with observations \code{x} and the
#'   number of columns must equal the mixture components \code{k}.
#' @param distribution supposed distribution of mixture model components.
#'   The value must be \code{"weibull"}. Other distributions have not been
#'   implemented yet.
#' @param k integer of mixture components, default is 2.
#' @param method default method is \code{"EM"}. Other methods have not been
#'   implemented yet.
#' @param n_iter integer defining the maximum number of iterations.
#' @param conv_limit numeric value defining the convergence limit.
#'
#' @return Returns a list with the following components:
#'   \itemize{
#'   \item \code{coefficients} : A matrix with estimated Weibull parameters. In the
#'     first row the estimated scale parameters \eqn{\eta} and in the second the
#'     estimated shape parameters \eqn{\beta} are provided. The first column belongs
#'     to the first mixture component and so forth.
#'   \item \code{posteriori} : A matrix with estimated a-posteriori probabilities.
#'   \item \code{priori} : A vector with estimated a-priori probabilities.
#'   \item \code{logL} : The value of the complete log-likelihood.}
#'
#' @keywords internal
mixture_em_cpp <- function(x, status, post, distribution = "weibull", k = 2L, method = "EM", n_iter = 100L, conv_limit = 1e-6) {
    .Call(`_weibulltools_mixture_em_cpp`, x, status, post, distribution, k, method, n_iter, conv_limit)
}

#' Computation of Johnson Ranks
#'
#' This function calculates the Johnson ranks which are used to estimate the
#' failure probabilities in case of (multiple) right censored data.
#'
#' @param f a numeric vector indicating the number of failed units for a
#'   specific realization of the lifetime characteristic.
#' @param n_out a numeric vector indicating the number of failed and censored
#'   units that have a shorter realization of lifetime characteristic as unit
#'   \emph{i}.
#' @param n an integer value indicating the sample size.
#'
#' @return A numeric vector containing the computed Johnson ranks.
#'
#' @keywords internal
calculate_ranks <- function(f, n_out, n) {
    .Call(`_weibulltools_calculate_ranks`, f, n_out, n)
}

