% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_bands_baseline}
\alias{predict_bands_baseline}
\title{Extract confidence and prediction bands for the baseline phase}
\usage{
predict_bands_baseline(
  .data,
  time_column,
  vo2_column,
  cleaning_level,
  cleaning_baseline_fit
)
}
\arguments{
\item{.data}{The nornalized data retrieved from \code{normalize_transitions()}. The data should be filtered to only the 'baseline' phase before passing to the function.}

\item{time_column}{The name (quoted) of the column containing the time. Depending on the language of your system, this column might not be "t". Therefore, you may specify it here.  Default to "t".}

\item{vo2_column}{The name (quoted) of the column containing the absolute oxygen uptake (VO2) data. Default to 'VO2'.}

\item{cleaning_level}{A numeric scalar between 0 and 1 giving the confidence level for the intervals to be calculated.}

\item{cleaning_baseline_fit}{A character indicating what kind of fit to perform for each baseline. Either 'linear' or 'exponential'.}
}
\value{
a \link[tibble:tibble-package]{tibble} containing the following columns:
\item{x}{The provided time data.}
\item{y}{The provided VO2 data.}
\item{.fitted}{The predicted response for that observation.}
\item{.resid}{The residual for a particular point.}
\item{lwr_conf}{Lower limit of the confidence band.}
\item{upr_conf}{Upper limit of the confidence band.}
\item{lwr_pred}{Lower limit of the prediction band.}
\item{upr_pred}{Upper limit of the prediction band.}
}
\description{
Extract confidence and prediction bands for the baseline phase
}
