% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_contour}
\alias{wbt_lidar_contour}
\title{Lidar contour}
\usage{
wbt_lidar_contour(
  input,
  output = NULL,
  interval = 10,
  smooth = 5,
  parameter = "elevation",
  returns = "all",
  exclude_cls = NULL,
  minz = NULL,
  maxz = NULL,
  max_triangle_edge_length = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR points.}

\item{output}{Name of the output vector lines file.}

\item{interval}{Contour interval.}

\item{smooth}{Smoothing filter size (in num. points), e.g. 3, 5, 7, 9, 11.}

\item{parameter}{Interpolation parameter; options are 'elevation' (default), 'intensity', 'user_data'.}

\item{returns}{Point return types to include; options are 'all' (default), 'last', 'first'.}

\item{exclude_cls}{Optional exclude classes from interpolation; Valid class values range from 0 to 18, based on LAS specifications. Example, --exclude_cls='3,4,5,6,7,18'.}

\item{minz}{Optional minimum elevation for inclusion in interpolation.}

\item{maxz}{Optional maximum elevation for inclusion in interpolation.}

\item{max_triangle_edge_length}{Optional maximum triangle edge length; triangles larger than this size will not be gridded.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates a vector contour coverage from an input LiDAR point file.
}
