% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{wbt_tin_gridding}
\alias{wbt_tin_gridding}
\title{Tin gridding}
\usage{
wbt_tin_gridding(
  input,
  output,
  field = NULL,
  use_z = FALSE,
  resolution = NULL,
  base = NULL,
  max_triangle_edge_length = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{input}{Input vector points file.}

\item{output}{Output raster file.}

\item{field}{Input field name in attribute table.}

\item{use_z}{Use the 'z' dimension of the Shapefile's geometry instead of an attribute field?.}

\item{resolution}{Output raster's grid resolution.}

\item{base}{Optionally specified input base raster file. Not used when a cell size is specified.}

\item{max_triangle_edge_length}{Optional maximum triangle edge length; triangles larger than this size will not be gridded.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a raster grid based on a triangular irregular network (TIN) fitted to vector points.
}
