% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbt-method.R
\name{wbt}
\alias{wbt}
\alias{wbt.wbt_result}
\alias{wbt_result}
\alias{wbt.character}
\alias{wbt.function}
\alias{wbt.missing}
\title{Run WhiteboxTools by Tool Name}
\usage{
wbt(
  result,
  tool_name,
  ...,
  crs = NULL,
  verbose_mode = FALSE,
  command_only = FALSE
)

\method{wbt}{wbt_result}(
  result,
  tool_name,
  ...,
  crs = NULL,
  verbose_mode = FALSE,
  command_only = FALSE
)

wbt_result(result, i = NULL, history = TRUE, attribute = "output")

\method{wbt}{character}(
  result,
  tool_name,
  ...,
  crs = NULL,
  verbose_mode = FALSE,
  command_only = FALSE
)

\method{wbt}{`function`}(
  result,
  tool_name,
  ...,
  crs = NULL,
  verbose_mode = FALSE,
  command_only = FALSE
)

\method{wbt}{missing}(
  result,
  tool_name,
  ...,
  crs = NULL,
  verbose_mode = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{result}{an object of class \code{wbt_result}}

\item{tool_name}{character. name of the tool to run. Or a tool/function name (i.e. a symbol) that is non-standard evaluated as a character.}

\item{...}{arguments to tool}

\item{crs}{character Optional: a WKT Coordinate Reference System string, or other identifier such as EPSG code or PROJ string}

\item{verbose_mode}{passed to \code{wbt_run_tool()}}

\item{command_only}{Return command that would be run with \code{system()}? Default: \code{FALSE}}

\item{i}{Optional index of result list element to return as result. Default is whole list.}

\item{history}{Default: \code{TRUE} returns a list of all history results}

\item{attribute}{Default: \code{"output"}}
}
\value{
a list with class \code{"wbt_result"} containing elements:
\itemize{
\item \code{tool} - the tool name
\item \code{args} - arguments passed to executable
\item \code{stdout} - console output (result of \code{wbt_run_tool()})
\item \code{crs} - Coordinate Reference System string (WKT or PROJ)
\item \code{result} - any 'result' parameters (\code{--output}) that can be converted to R objects after run. A list of RasterLayer or character. May be a \code{try-error} if arguments are specified incorrectly.
\item \code{history} - history of 'result' when \code{wbt_result} was passed as input, most recent output at end
}

list of result in \code{attribute} if \code{"history"} is present, otherwise the result in \code{attribute}. If \code{i} is specified, just the \code{i}th element of the list.
}
\description{
You are required to specify all required arguments as either paths to files, or R object types that can be associated with a file.

\code{wbt_result()}: return a combined list of results from either the history of a \code{wbt_result} (if present and \code{history=TRUE}), or the result of a \code{wbt_result}
}
\details{
Supports SpatRaster / RasterLayer input / output. Arguments are transformed from their source class and passed to WhiteboxTools executable as standard character string arguments involving file paths.

To print help for any tool, see \code{wbt_tool_help()}

\code{tool_name} may be specified with or without quotes or \code{wbt_} prefix. e.g. \code{"wbt_slope"}, \code{wbt_slope}, \code{slope}, and \code{"slope"} are identical.
}
\seealso{
\code{\link[=wbt_tool_help]{wbt_tool_help()}}
}
\keyword{General}
