% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{make_it_012}
\alias{make_it_012}
\title{just a quick function for making an 012 matrix from a character matrix}
\usage{
make_it_012(M)
}
\arguments{
\item{M}{a character matrix of variant call format (VCF) genotypes and no dimnames.  Allowable values are
"0/0", and "0|0", which get coverted to integer 0;  "0/1", "0|1", "1/0", and "1|0",
which get converted to integer 1; and
 "1/1", and "1|1", which get converted to integer 2.  Everything else gets
 converted to -1 to denote missing data.}
}
\value{
An integer matrix of values which are 0, 1, 2, or -1.
}
\description{
The standard way within R of pulling values out of a named
vector really bogs down on large data sets.  So I will do this instead.
}
\examples{
# get an 012 matrix from the lobster data
tmp <- t(vcfR::extract.gt(lobster_buz_2000, element = "GT"))
dimnames(tmp) <- NULL
g <- make_it_012(tmp)
}
