% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_metadata.R
\name{retrieve_metadata}
\alias{retrieve_metadata}
\title{Retrieves Meta Data from GENESIS Databases}
\usage{
retrieve_metadata(tablename, language = "de", genesis = NULL, ...)
}
\arguments{
\item{tablename}{name of the table to retrieve.}

\item{language}{retrieve information in German "de" (default) or in English "en" if available.}

\item{genesis}{to authenticate a user and set the database (see below).}

\item{...}{other arguments send to the httr::GET request.}
}
\value{
a \code{data.frame}.
}
\description{
\code{retrieve_metadata} retrieves meta data.
}
\details{
See the package description (\code{\link{wiesbaden}}) for details about setting the login and database.
}
\examples{

 \dontrun{
 # Meta data contain the explanations to the variable names for the table
 # federal election results on the county level. 
 # Assumes that user/password are stored via save_credentials()

 metadata <- retrieve_metadata(tablename="14111KJ002", genesis=c(db="regio") )
 }




}
\seealso{
\code{\link{wiesbaden}}
}
