% Generated by roxygen2 (4.0.1): do not edit by hand
\name{DI}
\alias{DI}
\title{Dynamic interaction index}
\usage{
DI(traj1, traj2, tc = 0, alpha = 1, local = FALSE, TimeWeight = FALSE,
  DistWeight = FALSE)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
traj} object. For more information on objects of this type see \code{help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{alpha}{value for the \eqn{\alpha} parameter in the formula for di\eqn{_d}.}

\item{TimeWeight}{whether or not to compute the weights for time-based weighting.}

\item{DistWeight}{whether or not to compute the weights for distance-based weighting.}

\item{local}{logical, whether or not to perform local analysis.}
}
\value{
The function DI returns the DI index (along with DI\eqn{_{theta}}{_theta} and DI\eqn{_d}), or if \code{local = TRUE},
a dataframe that contains the localized \code{di} values (see Long and Nelson 2013). The columns for \code{di},
\code{di.theta}, and \code{di.d} representdynamic interaction overall, in
direction (azimuth), and in displacement respectively. If time- and/or distance-based weighting
is selected, the corresponding weights are included as additional columns \code{t.weight} and \code{d.weight},
respectively. Please see Long and Nelson (2013) for a more detailed description.
}
\description{
The function \code{DI} measures dynamic interaction between two moving objects. It
calculates the local level di statistic for movement displacement, direction,
and overall. DI can compute time- and/or distance-based weighting schemes
following Long and Nelson (2013).
}
\details{
This function can be used for calculating the dynamic interaction (DI) statistic
as described in Long and Nelson (2013). The DI statistic can be used to measure
the local level of dynamic interaction between two moving objects. Specifically,
it measures dynamic interaction in movement direction and displacement.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes
DI(deer37, deer38, tc = 7.5*60)
df <- DI(deer37, deer38, tc = 7.5*60, local = TRUE)
}
\references{
Long, J.A., Nelson, T.A. 2013. Measuring dynamic interaction in movement
data. \emph{Transactions in GIS}. 17(1): 62-77.
}
\seealso{
GetSimultaneous, Cr
}
\keyword{indices}

