% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conSummary.R
\name{conSummary}
\alias{conSummary}
\title{Summarize contacts and phases}
\usage{
conSummary(ltraj)
}
\arguments{
\item{ltraj}{an object of the class \code{ltraj} which should be output from the function \code{conPhase}.}
}
\value{
A dataframe that can be used to summarize contact phases.
}
\description{
Computes some basic summary statistics from a contact analysis.
}
\details{
This function is used following the \code{conPhase} function. It computes the following summary statistics from the contact analysis:
- total number of fixes in the dataset
- total number of fixes deemed a contact
- number of contact phases
- longest phase duration
- mean phase duration
- median phase duration
- no. of phase where the duration is only one fix (i.e., instantaneous contacts)
}
\examples{
\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
conSummary(doephas)
}
}
\seealso{
conPhase
}
\keyword{contacts}
