% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltraj2sf.R
\name{ltraj2sf}
\alias{ltraj2sf}
\title{Convert ltraj to sf spatial object}
\usage{
ltraj2sf(traj, type = "point")
}
\arguments{
\item{traj}{an object of the class \code{ltraj} which contains the time-stamped movement fixes of the object. For more information on objects of this type see \code{help(ltraj)}.}

\item{type}{One of \code{"point"} (the default) or \code{"line"}.}
}
\value{
A \code{sf} object either points or lines.
}
\description{
The function \code{ltraj2sf} is a simple function for converting ltraj to sf objects.
}
\details{
The function \code{ltraj2sf} can be used to convert an \code{ltraj} object into an \code{sf} spatial object (either as points or lines).
}
\examples{
data(deer)
#points
deer_pt <- ltraj2sf(deer)
plot(deer_pt['id'])

#lines
deer_ln <- ltraj2sf(deer,type='line')
plot(deer_ln['id'])
}
\seealso{
conSpatial,sf2ltraj
}
\keyword{processing}
