% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDistributionSummary.R
\name{getDistributionSummary}
\alias{getDistributionSummary}
\title{Summary statistics from the fitted distribution}
\usage{
getDistributionSummary(distribution, paramVec, truncBounds = NULL, ...)
}
\arguments{
\item{distribution}{String indicating which distribution to use.}

\item{paramVec}{Numeric vector for the parameters associated with distribution. Assumed to be in the same order as the function indicated by \code{distribution}.}

\item{truncBounds}{Numeric, indicating bounds for the area correction calculation, see details. Default is NULL, and the bounds are set to \code{c(0,Inf)}.}

\item{...}{Additional arguments to \code{\link[stats]{integrate}}.}
}
\value{
Data frame with the summary statistics.
}
\description{
Summary statistics are calculated for the distribution with parameter estimates. Right now only the median is produced.
}
\details{
The \code{truncBounds} argument defaults to zero as a lower bound and infinity
  as the upper bound. If a single value is provided, it is assumed as the upper
  bound with zero as the lower bound. If two or more values are provided, the
  \code{max(truncBounds)} is the upper bound and \code{min(truncBounds)} is the
  lower bound.
}
\examples{

getDistributionSummary('norm',c(40,25),truncBounds=c(-Inf,Inf))

getDistributionSummary('norm',c(40,25),truncBounds=NULL)

getDistributionSummary('norm',c(40,25),truncBounds=c(0,30))

}
