% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDistanceProbability.R
\name{getDistanceProbability}
\alias{getDistanceProbability}
\title{Calculate probabilities within one unit increments.}
\usage{
getDistanceProbability(
  q,
  distribution,
  param1,
  param2 = NA,
  tbound = c(-Inf, Inf),
  unitSize = 1,
  ...
)
}
\arguments{
\item{q}{Vector of quantiles.}

\item{distribution}{Character value; specifying the desired probability distribution, see \code{\link{ptrunc}}.}

\item{param1}{Numeric; value of the first parameter of the specified distribution.}

\item{param2}{Numeric; default is \code{NA}. Value of the second parameter of the specified distribution, if applicable.}

\item{tbound}{Numeric vector specifying the lower and upper truncation bounds. Default is \code{c(-Inf, Inf)}.}

\item{unitSize}{Numeric; either of length one or equal to \code{length(q)}, specific the desired width for the probability calculation. Default is 1.}

\item{...}{Currently ignored.}
}
\value{
Vector of probabilities
}
\description{
Probabilities are calculated between specified increments for a given distribution and parameter values.
}
\details{
This is a wrapper function that uses the \code{\link{ptrunc}} function. The basic calculation is \code{ptrunc(q,...) - ptrunc(q-abs(unitSize),...)}
}
\examples{
## normal distribution
getDistanceProbability(q=8,distribution='norm',param1=10,param2=1)
pnorm(8,mean=10,sd=1)-pnorm(8-1,mean=10,sd=1)

## larger unitSize
getDistanceProbability(q=12,distribution='norm',param1=10,param2=1,unitSize=4)
pnorm(12,mean=10,sd=1)-pnorm(12-4,mean=10,sd=1)

}
\seealso{
ptrunc
}
