% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GooglePlot.R
\name{GooglePlot}
\alias{GooglePlot}
\title{Plot the \code{best} Results with Google background map}
\usage{
GooglePlot(result, Polygon1, best = 1, plotEn = 1, Projection, ...)
}
\arguments{
\item{result}{The output matrix of \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information.
(matrix)}

\item{Polygon1}{The considered area as shapefile (SpatialPolygons)}

\item{best}{A numeric value indicating which best individuals
to be plotted. 1 will indicate the solution with highest value. (numeric)}

\item{plotEn}{A numeric value that indicates if the best energy or
efficiency output should be plotted. (plotEn==1) will plot the best
energy solution and (plotEn==2) will plot the best efficiency solution.
(numeric)}

\item{Projection}{A desired Projection can be used instead
of the default Lambert Azimuthal Equal Area Projection. (character)}

\item{...}{Some arguments can be passed to
\link[RgoogleMaps]{GetMap} and \link[RgoogleMaps]{PlotOnStaticMap},
of the 'RgoogleMaps' package including \code{maptype}, \code{col},
\code{cex}, \code{pch}, \code{size} and \code{zoom}. If the plot is not
required, it can be disabled with the option \code{plT = FALSE}.
Check the examples for some action.}
}
\value{
Returns a data.frame with the coordinates in LON/LAT and plots
the desired best result with a Google background map. (data.frame)
}
\description{
Plot the best energy or efficiency solutions with a
background image of Google maps.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))
load(file = system.file("extdata/polygon.rda", package = "windfarmGA"))

## Plot the results of a wind farm optimization
result <- resultrect
Polygon1 <- polygon

GooglePlot(result, Polygon1, 1, 1)
GooglePlot(result, Polygon1, 2, 1, zoom=14, maptype="hybrid",
           col="darkblue", pch=18)
GooglePlot(result, Polygon1, 3, 1, zoom=14, maptype="terrain",
           col="black", pch=20)
GooglePlot(result, Polygon1, 3, 2, zoom=15, maptype="satellite",
           col="red", pch=10)
GooglePlot(result, Polygon1, 1, 1, zoom=14, maptype="mobile",
           col="darkblue", pch=17)
GooglePlot(result, Polygon1, 1, 1, zoom=14, maptype="hybrid",
           col="darkblue", pch=20)
GooglePlot(result, Polygon1, 1, 1, zoom=14, maptype="hybrid",
           col="blue", pch=18, cex= 2)
GooglePlot(result, Polygon1, 1, 1, zoom=14, maptype="hybrid",
           col="blue", pch=18, cex= 2, size=c(320,320))

}
}
\author{
Sebastian Gatscha
}
