% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaroHoehe.R
\name{BaroHoehe}
\alias{BaroHoehe}
\title{Calculates Air Density, Air Pressure and Temperature according
to the Barometric Height Formula}
\usage{
BaroHoehe(data, height, po = 101325, ro = 1.225)
}
\arguments{
\item{data}{A data.frame containing the height values}

\item{height}{Column name of the height values}

\item{po}{Standardized air pressure at sea level (101325 Pa)}

\item{ro}{Standardized air density at sea level (1,225 kg per m3)}
}
\value{
Returns a data.frame with height values and corresponding
air pressures, air densities and temperatures in Kelvin and Celsius.
}
\description{
Calculates air density, temperature and air pressure
    respective to certain heights according to the International
    standard atmosphere and the barometric height formula.
}
\examples{
data <- matrix(seq(0,5000,500));
BaroHoehe(data)
plot.ts(BaroHoehe(data))

}
\author{
Sebastian Gatscha
}
