% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{rasterprofile}
\alias{rasterprofile}
\title{Sample values from a raster}
\usage{
rasterprofile(r, xy1, xy2, reso, plot = FALSE)
}
\arguments{
\item{r}{A DEM raster}

\item{xy1}{A matrix with X and Y coordinates for Point 1}

\item{xy2}{A matrix with X and Y coordinates for Points 2}

\item{reso}{The minimal resolution of the DEM raster. It is 
calculated in \code{viewshed} and passed along.}

\item{plot}{Plot the process? Default is \code{FALSE}}
}
\value{
A boolean vector, indicating if Point 1 (xy1) is visible from all
  elements of Points 2 (xy2)
}
\description{
Sample a raster along a straight line between 2 points
}
\seealso{
Other Viewshed Analysis: 
\code{\link{cansee}()},
\code{\link{interpol_view}()},
\code{\link{plot_viewshed}()},
\code{\link{viewTo}()},
\code{\link{viewshed}()}
}
\concept{Viewshed Analysis}
