% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation.R
\name{mutation}
\alias{mutation}
\title{Mutation Method}
\usage{
mutation(a, p, seed = NULL)
}
\arguments{
\item{a}{The binary matrix of all individuals}

\item{p}{The mutation rate}

\item{seed}{Set a seed for comparability. Default is \code{NULL}}
}
\value{
Returns a binary matrix with mutated genes.
}
\description{
The function randomly mutates an individual's genetic code
}
\examples{
## Create 4 random individuals with binary values
a <- cbind(
  bin0 = sample(c(0, 1), 20, replace = TRUE, prob = c(70, 30)),
  bin1 = sample(c(0, 1), 20, replace = TRUE, prob = c(30, 70)),
  bin2 = sample(c(0, 1), 20, replace = TRUE, prob = c(30, 70)),
  bin3 = sample(c(0, 1), 20, replace = TRUE, prob = c(30, 70))
)
a

## Mutate the individuals with a low percentage
aMut <- mutation(a, 0.1, NULL)
## Check which values are not like the originals
a == aMut

## Mutate the individuals with a high percentage
aMut <- mutation(a, 0.4, NULL)
## Check which values are not like the originals
a == aMut

}
\seealso{
Other Genetic Algorithm Functions: 
\code{\link{crossover}()},
\code{\link{fitness}()},
\code{\link{genetic_algorithm}()},
\code{\link{init_population}()},
\code{\link{selection}()},
\code{\link{trimton}()}
}
\concept{Genetic Algorithm Functions}
