% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewtr.R
\name{EWTR}
\alias{EWTR}
\title{Expected win time against reference}
\usage{
EWTR(
  n,
  m,
  nunique,
  maxfollow,
  untimes,
  Time,
  Delta,
  dist,
  markov_ind,
  cov,
  trt
)
}
\arguments{
\item{n}{The total number of trial participants.}

\item{m}{The number of events in the hierarchy.}

\item{nunique}{The number of unique control group event times (returned from wintime::markov() or wintime::km()).}

\item{maxfollow}{The max control group follow up time (days) (returned from wintime::markov() or wintime::km()).}

\item{untimes}{A vector containing unique control group event times (days) (returned from wintime::markov() or wintime::km()).}

\item{Time}{A m x n matrix of event times (days). Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{Delta}{A m x n matrix of event indicators Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{dist}{A matrix of control group state probabilities (returned from wintime::markov() or wintime::km()).}

\item{markov_ind}{An indicator of the model type used (1 for Markov, 0 for Kaplan-Meier).}

\item{cov}{A n x p matrix of covariate values, where p is the number of covariates.}

\item{trt}{A vector of length n containing treatment arm indicators (1 for treatment, 0 for control).}
}
\value{
A list containing: The estimated treatment effect from the linear regression model, the variance, and the Z-statistic.
}
\description{
Calculates the control group state space probabilities using a Markov model (recommended) or a Kaplan-Meier model. This function uses these
probabilities to compare each participant's clinical state to a distribution of control group states.
}
