% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_means.R
\name{row_means}
\alias{row_means}
\alias{row_means.matrix}
\alias{row_means.data.frame}
\title{Row-wise means}
\usage{
row_means(.data, ...)

\method{row_means}{matrix}(.data, cumulative = FALSE, output_mode, output_class, ...)

\method{row_means}{data.frame}(.data, cumulative = FALSE, output_mode, output_class, ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{na_action}}{One of ("exclude", "pass"), possibly abbreviated. See \link[stats:na.pass]{stats::na.pass} for
semantics.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
  }}

\item{cumulative}{Logical. Whether to return the cumulative operation.}

\item{output_mode}{Passed to \code{\link[=op_ctrl]{op_ctrl()}}. If missing, it will be inferred.}

\item{output_class}{Passed to \code{\link[=op_ctrl]{op_ctrl()}}. If missing, it will be inferred.}
}
\description{
Row-wise means
}
\examples{

mat <- matrix(rnorm(10L), nrow = 2L, ncol = 5L)

row_means(mat)

# semantically, this is like looking for row means that are different from zero
# (but not missing)
mat[1L] <- NA_real_
row_means(mat, output_mode = "logical", na_action = "pass")

}
