% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qkn_coeffn.R
\name{qkn_coeffn}
\alias{qkn_coeffn}
\title{Inverse of a Coefficient Matrix \eqn{\tilde{\mathcal{C}}_k}}
\usage{
qkn_coeffn(k, n1, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\tilde{\mathcal{C}}_k} matrix}

\item{n1}{The parameter \eqn{n - m + 1 - \alpha}, where:
\itemize{
\item \eqn{n} is the degrees of freedom of \eqn{W}
\item \eqn{m} is the number of rows of \eqn{W}
}}

\item{alpha}{The type of beta-Wishart distribution (\eqn{\alpha=2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
Inverse of a coefficient matrix \eqn{\tilde{\mathcal{C}}_k} that allows us to
obtain \eqn{E[p_{\lambda}(W^{-1})W^{-r}]}, where \eqn{r+|\lambda|=k}
and \eqn{W ~ W_m^{\beta}(n,\Sigma)}
}
\description{
This function computes the inverse of the coefficient matrix \eqn{\tilde{\mathcal{C}}_k}
}
\examples{
# Example 1:
qkn_coeffn(2, 20) # For real Wishart distribution with k = 2 and n1 = 20
# Example 2:
qkn_coeffn(3, 20, 1) # For complex Wishart distribution with k = 3 and n1 = 20

# Example 3:
qkn_coeffn(2, 20, 1/2) # For quaternion Wishart distribution with k = 2 and n1 = 20

}
