% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-extract.R
\name{grd_extract}
\alias{grd_extract}
\alias{grd_extract_nearest}
\alias{grd_data_extract}
\title{Extract values from a grid}
\usage{
grd_extract(grid, i = NULL, j = NULL)

grd_extract_nearest(grid, point, out_of_bounds = c("censor", "squish"))

grd_data_extract(grid_data, i = NULL, j = NULL)
}
\arguments{
\item{grid}{A \code{\link[=grd_xy]{grd_xy()}}, \code{\link[=grd_rct]{grd_rct()}}, or other object
implementing \verb{grd_*()} methods.}

\item{i, j}{Index values as in \code{\link[=grd_subset]{grd_subset()}} except recycled to a common
size.}

\item{point}{A \link[=wk_handle]{handleable} of points.}

\item{out_of_bounds}{One of 'keep', 'censor', 'discard', or 'squish'}

\item{grid_data}{The \code{data} member of a \code{\link[=grd]{grd()}}. This is typically an
array but can also be an S3 object with an array-like subset method.
The \link[grDevices:as.raster]{native raster} is special-cased as its
subset method requires non-standard handling.}
}
\value{
A matrix or vector with two fewer dimensions than the input.
}
\description{
Unlike \code{\link[=grd_subset]{grd_subset()}}, which subsets like a matrix, \code{\link[=grd_extract]{grd_extract()}} returns
values.
}
