% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-versions.R
\name{wood_github_versions}
\alias{wood_github_versions}
\title{Get all tagged package versions on GitHub}
\usage{
wood_github_versions(package, user)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{user}{\code{character(1)}\cr
Name of a user or organization.}
}
\value{
A character vector of version codes.
}
\description{
This function queries GitHub for the codes of all tagged package
versions. To get the latest available version, see \code{\link[=wood_github_latest]{wood_github_latest()}}.
}
\examples{
\donttest{
wood_github_versions("versionsort", "turtletopia")
}

}
\seealso{
Functions for GitHub:
\code{\link{wood_github_dependencies}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_github_tags}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{github}
\concept{versions}
