% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runiverse-dependencies.R
\name{wood_runiverse_dependencies}
\alias{wood_runiverse_dependencies}
\title{Get dependencies of a package in one of R universes}
\usage{
wood_runiverse_dependencies(package, universe = "ropensci")
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{universe}{\code{character(1)}\cr
Name of a universe within R-universe, e.g. "ropensci".}
}
\value{
A data frame with three columns, all in string format:
\itemize{
\item \code{package} (package name),
\item \code{version} (minimum version requirement or \code{NA} if none),
\item \code{type} (dependency type, e.g. \code{"Imports"}).
}
}
\description{
This function queries the selected universe for dependencies
of the selected package.
}
\examples{
\donttest{
wood_runiverse_dependencies("targets")
wood_runiverse_dependencies("ggplot2", universe = "tidyverse")
}

}
\seealso{
Functions for R-universe:
\code{\link{wood_runiverse_packages}()},
\code{\link{wood_runiverse_version}()}

Functions that query package dependencies:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_core_dependencies}()},
\code{\link{wood_cran_dependencies}()},
\code{\link{wood_dependencies}()},
\code{\link{wood_github_dependencies}()},
\code{\link{wood_local_dependencies}()},
\code{\link{wood_url_dependencies}()}
}
\concept{dependencies}
\concept{runiverse}
