% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_git_commit.R
\name{wflow_git_commit}
\alias{wflow_git_commit}
\title{Commit files}
\usage{
wflow_git_commit(files = NULL, message = NULL, all = FALSE,
  force = FALSE, dry_run = FALSE, project = ".")
}
\arguments{
\item{files}{character (default: NULL). Files to be added and committed with
Git. Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.}

\item{message}{character (default: NULL). A commit message.}

\item{all}{logical (default: FALSE). Automatically stage files that have been
modified and deleted. Equivalent to: \code{git commit -a}}

\item{force}{logical (default: FALSE). Allow adding otherwise ignored files.
Equivalent to: \code{git add -f}}

\item{dry_run}{logical (default: FALSE). Preview the proposed action but do
not actually add or commit any files.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_git_commit}, which is a list with the
  following elements:

\itemize{

\item \bold{files}: The input argument \code{files}.

\item \bold{message}: The message describing the commit.

\item \bold{all}: The input argument \code{all}.

\item \bold{force}: The input argument \code{force}.

\item \bold{dry_run}: The input argument \code{dry_run}.

\item \bold{commit}: The \code{\link[git2r]{git_commit-class}} object
returned by \link{git2r} (only included if \code{dry_run == FALSE}).

\item \bold{commit_files}: The relative path(s) to the file(s) included in
the commit (only included if \code{dry_run == FALSE}).

}
}
\description{
\code{wflow_git_commit} adds and commits files with Git. This is a convenience
function to run Git commands from the R console instead of the shell. For
most use cases, you should use \code{\link{wflow_publish}} instead, which
calls \code{wflow_git_commit} and then subsequently also builds and commits the
website files.
}
\details{
Some potential use cases for \code{wflow_git_commit}:

\itemize{

\item Commit drafts which you do not yet want to be included in the website

\item Commit files which do not directly affect the website (e.g. when you
are writing scripts for a data processing pipeline)

\item Manually commit files in \code{docs/} (proceed with caution!). This
should only be done for content that is not automatically generated from the
source files in the analysis directory, e.g. an image file you want to
include in one of your pages.

}

Under the hood, \code{wflow_git_commit} is a wrapper for \code{\link[git2r]{add}}
and \code{\link[git2r]{commit}} from the package \link{git2r}.
}
\examples{
\dontrun{

# Commit a single file
wflow_git_commit("analysis/file.Rmd", "Add new analysis")
# Commit multiple files
wflow_git_commit(c("code/process-data.sh", "output/small-data.txt"),
             "Process data set")
# Add and commit all tracked files, similar to `git commit -a`
wflow_git_commit(message = "Lots of changes", all = TRUE)
}

}
\seealso{
\code{\link{wflow_publish}}
}
