% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_use_github.R
\name{wflow_use_github}
\alias{wflow_use_github}
\title{Deploy site with GitHub}
\usage{
wflow_use_github(username = NULL, repository = NULL,
  navbar_link = TRUE, protocol = "https", domain = "github.com",
  project = ".")
}
\arguments{
\item{username}{character (default: NULL). The GitHub username for the remote
repository. If not specified, workflowr will attempt to guess this from the
current remote named "origin" if it had previously been configured.}

\item{repository}{character (default: NULL). The name of the remote
repository on GitHub. If not specified, workflowr will attempt to guess
this from the current remote named "origin" if it had previously been
configured.}

\item{navbar_link}{logical (default: TRUE). Insert a link to the GitHub
repository into the navigation bar.}

\item{protocol}{character (default: "https"). The protocol for communicating
with GitHub. Must be either "https" or "ssh".}

\item{domain}{character (default: "github.com"). The domain of the remote
host. You only need to change this if your organization is using GitHub
Enterprise.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns a list of class \code{wflow_use_github}. This is
  currently for internal use only. Please open an Issue if you'd like to use
  this information.
}
\description{
\code{wflow_use_github} automates all the local configuration necesary to
deploy your workflowr project with \href{https://pages.github.com/}{GitHub
Pages}. However, you will need to manually login to your account and create
the new repository on GitHub. The final step is to run \code{wflow_git_push}
in the R console.
}
\details{
\code{wflow_use_github} performs the following steps and then commits the
changes:

\itemize{

\item Adds a link to the GitHub repository in the navigation bar

\item Configures the Git remote settings to use GitHub

\item (Only if necessary) Renames the website directory to \code{docs/}

\item (Only if necessary) Edits the setting \code{output_dir} in the file
\code{_site.yml} to save the website files in \code{docs/}

}

For more details, read the documentation provided by
\href{https://pages.github.com/}{GitHub Pages}.
}
\examples{
\dontrun{

wflow_use_github("your-username", "name-of-repository")
# Login with GitHub account and create new repository
wflow_git_push()
}

}
\seealso{
\code{\link{wflow_git_push}}, \code{\link{wflow_git_remote}},
         \code{\link{wflow_use_gitlab}}
}
