% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_team_player_stats.R
\name{fb_team_player_stats}
\alias{fb_team_player_stats}
\title{Get fbref Team's Player Season Statistics}
\usage{
fb_team_player_stats(team_urls, stat_type, time_pause = 3)
}
\arguments{
\item{team_urls}{the URL(s) of the teams(s) (can come from fb_teams_urls())}

\item{stat_type}{the type of statistic required}

\item{time_pause}{the wait time (in seconds) between page loads

The statistic type options (stat_type) include:

\emph{"standard"}, \emph{"shooting"}, \emph{"passing"},
\emph{"passing_types"}, \emph{"gca"}, \emph{"defense"}, \emph{"possession"}
\emph{"playing_time"}, \emph{"misc"}, \emph{"keeper"}, \emph{"keeper_adv"}}
}
\value{
returns a dataframe of all players of a team's season stats
}
\description{
Returns the team's players season stats for a selected team(s) and stat type
}
\examples{
\dontrun{
try({
fb_team_player_stats("https://fbref.com/en/squads/d6a369a2/Fleetwood-Town-Stats",
                       stat_type = 'standard')

league_url <- fb_league_urls(country = "ENG", gender = "M",
                                             season_end_year = 2022, tier = "3rd")
team_urls <- fb_teams_urls(league_url)
multiple_playing_time <- fb_team_player_stats(team_urls,
                         stat_type = "playing_time")
})
}
}
